﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GTA;

namespace NomeScripts
{
    public delegate void InputDelegate();

    public class GTAKeyboard
    {
        public Dictionary<System.Windows.Forms.Keys, InputDelegate> KeyMapping
        {
            get { return keyMapping; }
        }

        ControllerParser controllerParser;
        Dictionary<System.Windows.Forms.Keys, InputDelegate> keyMapping;
        Dictionary<System.Windows.Forms.Keys, bool> keyDownMap;

        public GTAKeyboard()
        {
            controllerParser = new ControllerParser();
            keyMapping = new Dictionary<System.Windows.Forms.Keys, InputDelegate>();
            keyDownMap = new Dictionary<System.Windows.Forms.Keys, bool>();
        }

        public bool LoadKeys(IniFile iniFile, params KeyValuePair<String, InputDelegate>[] keys)
        {
            try
            {
                foreach (KeyValuePair<String, InputDelegate> pair in keys)
                {
                    System.Windows.Forms.Keys key = controllerParser.StringToKeyboardKey(iniFile.IniReadValue("Controls-Keyboard", pair.Key));

                    if (!controllerParser.CheckKeyIsValid(key))
                    {
                        return false;
                    }

                    keyMapping.Add(key, pair.Value);
                    keyDownMap.Add(key, false);
                }
            } catch (NullReferenceException) {
                Game.Console.Print("Check iniFile for valid keyboard controls");
                keyMapping.Clear();
                return false;
            } catch (ArgumentException) {
                Game.Console.Print("Check iniFile for valid keyboard controls OR check you are not passing the same key");
                keyMapping.Clear();
                return false;
            }

            return true;
        }

        public bool LoadKeys(params KeyValuePair<String, InputDelegate>[] keys)
        {
            try
            {
                foreach (KeyValuePair<String, InputDelegate> pair in keys)
                {
                    System.Windows.Forms.Keys key = controllerParser.StringToKeyboardKey(pair.Key);

                    if (!controllerParser.CheckKeyIsValid(key))
                    {
                        return false;
                    }

                    keyMapping.Add(key, pair.Value);
                }
            } catch (NullReferenceException) {
                Game.Console.Print("Check iniFile for valid keyboard controls");
                keyMapping.Clear();
                return false;
            } catch (ArgumentException) {
                Game.Console.Print("Check iniFile for valid keyboard controls OR check you are not passing the same delegate");
                keyMapping.Clear();
                return false;
            }

            return true;
        }

        public bool isKeysDown()
        {
            foreach (System.Windows.Forms.Keys key in keyDownMap.Keys)
            {
                if (keyDownMap[key]) return true;
            }

            return false;
        }

        public bool isKeyDown(System.Windows.Forms.Keys key)
        {
            bool isDown = false;
            try
            {
                isDown = keyDownMap[key];
            } catch (KeyNotFoundException) { }

            return isDown;
        }

        public void SetKeyDown(System.Windows.Forms.Keys key)
        {
            try
            {
                keyDownMap[key] = true;
            }
            catch (KeyNotFoundException) { }
        }

        public void SetKeyUp(System.Windows.Forms.Keys key)
        {
            try
            {
                keyDownMap[key] = false;
            }
            catch (KeyNotFoundException) { }
        }
    }
}
